#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Raymarching - bendy 3d shaplinesMod01.fsh  by   sancho1509    
//https://www.shadertoy.com/view/XcfGD7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


// Shpaes distance func
float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}
float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xy)-t.x,p.z);
  return length(q)-t.y;
}
float sdOctahedron( vec3 p, float s)
{
  p = abs(p);
  float m = p.x+p.y+p.z-s;
  vec3 q;
       if( 3.0*p.x < m ) q = p.xyz;
  else if( 3.0*p.y < m ) q = p.yzx;
  else if( 3.0*p.z < m ) q = p.zxy;
  else return m*0.57735027;
    
  float k = clamp(0.5*(q.z-q.y+s),0.0,s); 
  return length(vec3(q.x,q.y-s+k,q.z-k)); 
}

float sdPyramid( vec3 p, float h )
{
  float m2 = h*h + 0.25;
    
  p.xz = abs(p.xz);
  p.xz = (p.z>p.x) ? p.zx : p.xz;
  p.xz -= 0.5;

  vec3 q = vec3( p.z, h*p.y - 0.5*p.x, h*p.x + 0.5*p.y);
   
  float s = max(-q.x,0.0);
  float t = clamp( (q.y-0.5*p.z)/(m2+0.25), 0.0, 1.0 );
    
  float a = m2*(q.x+s)*(q.x+s) + q.y*q.y;
  float b = m2*(q.x+0.5*t)*(q.x+0.5*t) + (q.y-m2*t)*(q.y-m2*t);
    
  float d2 = min(q.y,-q.x*m2-q.y*0.5) > 0.0 ? 0.0 : min(a,b);
    
  return sqrt( (d2+q.z*q.z)/m2 ) * sign(max(q.z,-p.y));
}

float sdEllipsoid( vec3 p, vec3 r )
{
  float k0 = length(p/r);
  float k1 = length(p/(r*r));
  return k0*(k0-1.0)/k1;
}

//Utils

float smin(float a, float b, float k)
{
    float h = max(k- abs(a-b), 0.0)/k;
    return min(a,b) - h*h*h*k*(1.0/6.0);
}

vec3 rot3D(vec3 p, vec3 axis, float angle)
{
    return mix(dot(axis,p) * axis, p, cos(angle)) + cross(axis,p) * sin(angle);
}

mat2 rot2D(float angle)
{
     float s = sin(angle);
     float c = cos(angle);
     
     return mat2(c, -s, s, c);
}


// Custom gradient - https://iquilezles.org/articles/palettes/
vec3 palette(float t) {
    float time = iTime*0.05;
    time += 230.; // Time offset
    vec3 vector = vec3(
        clamp( smoothstep(0.2, 0.8, 0.8 + 0.5 * sin(0.6 * time)), 0.3, .7),
        clamp( smoothstep(0.2, 0.8, 0.5 + 0.5 * cos(0.8 * time + 2.0)), 0.5, .6),
        clamp( smoothstep(0.2, 0.8, 0.5 + 0.5 * sin(1.5 * time + 4.0)), 0.2, .4)
    );

    return .5+.5*cos(6.28318*(t+vector));
}

float movementCurve( float x) {
    return -2.0 / (1.0 + exp(-10.0 * (0.5 * x - 0.5))) + 1.0;
}

float PI = 3.1416;
float fovMult(float x, float a, float d) 
{
    return a + d + sin(PI * x - sqrt(PI)) * a;
}

//Render
float map(vec3 p)
{
    vec3 q = p;
    
    q.z +=  iTime*-1.;//smootherstep(0.,1.,sin(iTime));
    
    
    q.xy = fract(vec2(q.x, q.y)) - .5;
    q.z = mod(q.z, .3) - .125;
    
    float size = 1.;
    float oct = sdEllipsoid(q, vec3(fovMult(iTime*0.1, 0.6, 0.)*.3));
    //float oct = sdTorus(q, vec2(fovMult(iTime*0.05, 0.6, 0.1)/2., fovMult(iTime*0.05, 0.6, 0.1)/10.));
    
    return oct;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (fragCoord * 2. - iResolution.xy) / iResolution.y;
    
    
    
    //Movement
    vec2  m = (iMouse.xy * 2. - iResolution.xy) / iResolution.y;
    if (iMouse.z < 0.) 
        m = vec2(cos(iTime*.05), sin(iTime*.25));
    
        
    
    vec3 ro = vec3(0,0,-5);           //Ray origin
    vec3 rd = normalize(vec3(uv/(5.*fovMult( iTime*0.01, 0.57, 0.03)),1));  // Ray direction
    vec3 col = vec3(0);
    
    float t = 0.;                     //Distance travelled
    
    int i = 0;
    for( ;i < 130; i++)
    {
        vec3 p = ro + rd*t;
        //Sound
        // the sound texture is 512x2
        int tx = int((t/10000.)*512.0);

        // first row is frequency data (48Khz/4 in 512 texels, meaning 23 Hz per texel)
        float fft  = texelFetch( texture0, ivec2(tx,0), 0 ).x; 

        float wave = texelFetch( texture0, ivec2(tx,1), 0 ).x;
        
        
        p.y += 0.5* sin(t*(m.y+1.)*.5)*.7;
        p.xy *= rot2D(t*.2*m.x);
        p.y += asin(cos(tan(cos(t+6.*fovMult(iTime*0.02, 0.8, 0.3)))*fft)/10.) ;
        
        p.y += 0.5*cos(t*(m.y+1.5)*.5)*.7;
        
        float d = map(p);
        
        t += d;
        
        if(t >= 10000. || d <= 0.0003) break;
        
    }
    
    
    col = palette(t*0.01+float(i)*0.01);
    
    fragColor = vec4(col,1);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

